const $ = x => document.querySelector(x)
const hide = arr => arr.forEach(id=>$('#'+id).style.display="none")
const show = arr => arr.forEach(id=>$('#'+id).style.display="initial")
let drive,webViewLink,recordingType,fileId

function getUrlVars() {
    var vars = {};
    var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function(m,key,value) {
        vars[key] = value;
    });
    return vars;
}

let urlVars= getUrlVars()
recordingType=urlVars.type
// if (recordingType=='audio'){
//   $('#mainHeading').textContent="Record An Audio Comment"
// }
// else{
//   $('#mainHeading').textContent="Record A Video Comment"
// }

$('#closeWindow').addEventListener('click',()=>{
  window.close();
})

function selectAudioComment(){
  //$('#recordingIcon').innerText='🎙'
  $('audio').style.display='block';
  $('video').style.display='none';  
  // $('#audioSelected').checked=true;
  recordingType='audio'
  startStream()
}
function selectVideoComment(){
  //$('#recordingIcon').innerText='🎥'
  $('audio').style.display='none';
  $('video').style.display='block';  
  // $('#videoSelected').checked=true;
  recordingType='video'
  startStream()
}


// $('#audioSelected').addEventListener('click',selectAudioComment)
// $('#videoSelected').addEventListener('click',selectVideoComment)
if (recordingType=='audio')selectAudioComment()
if (recordingType=='video')selectVideoComment()

$('#startRecording').addEventListener('click',()=>{stateChange("recording")})
$('#stopRecording').addEventListener('click',()=>{stateChange("finishedRecording")})
$('#error').addEventListener('click',()=>{location.reload()})
$('#deleteRecording').addEventListener('click',()=>{
	stateChange("initial")
  if (recordingType=='video')selectVideoComment()
  else if (recordingType=='audio')selectAudioComment()
})
$('#saveRecording').addEventListener('click',()=>addComment('save'))
$('#postRecording').addEventListener('click',()=>addComment('immediate'))
$('#writeAbbreviation').addEventListener('click',()=>stateChange("writingAbbreviation"))

function stateChange(newState){
  if (newState=="initial"){
    hide(['nowRecording','deleteRecording','saveRecording',
      'writeAbbreviation','abbreviation','postRecording','saving','error'])
    show(['startRecording','closeWindow'])//'selectType',
  }
  else if (newState=="error"){
    hide(['startRecording','closeWindow'])
    show(['error'])
  }
  else if (newState=="recording"){
    hide(['startRecording'])//'selectType',
    show(['nowRecording'])
  }
  else if (newState=="finishedRecording"){
    hide(['nowRecording'])
    show(['postRecording','writeAbbreviation','deleteRecording'])
  }
  else if (newState=="writingAbbreviation"){
    hide(['postRecording','deleteRecording','closeWindow','writeAbbreviation'])
    show(['abbreviation','saveRecording'])
  }
  else if (newState=="saving"){
    hide(['writeAbbreviation','closeWindow','abbreviation',
      'postRecording','saveRecording','deleteRecording','closeWindow'])
    $('#saving').style.display="block"
  }
}
stateChange("initial")

async function addComment(postType){
  if (postType=='save' && $('#abbreviation').value=='') return;
  
  stateChange("saving")

  drive = await setToken()
  // console.log('Login',loginResponse)
  
  let UploadFileResponse = await insertFileData(fileToSend)
  fileId = UploadFileResponse.id
  //console.log('Post File',UploadFileResponse)
  
  await addSharedPermission(fileId)
  
  let fileList = await listFiles()
  webViewLink = fileList.files.find(el => el.id == fileId).webViewLink
  //console.log(webViewLink)

  let abbreviation = $('#recordingIcon').innerText+' '+$('#abbreviation').value
  let contents

  if (recordingType=='video') contents = '🎞 Click to watch a video comment: '+webViewLink
  else if (recordingType=='audio') contents = '🔈 Click to listen to an audio comment: '+webViewLink
    
  chrome.tabs.sendMessage(Number(urlVars.tabId), 
    {data: "addAVComment",contents,abbreviation,categoryId:urlVars.categoryId,postType,recordingType});
  //console.log(abbreviation,contents)
  window.close();
}

async function addSharedPermission(file_id){
    return new Promise(function (resolve, reject) {
        gapi.client.request({
            'path': '/drive/v3/files/' + file_id + '/permissions',
            'method': 'POST',
            'body': {
                "type": 'anyone',
                "role": 'reader',
            }
        }).execute(response => response.error ? reject(response.error) : resolve(response))
    })
}


/**
 * Insert new file.
 *
 * @param {File} fileData File object to read data from.
 * @param {Function} callback Callback function to call when the request is complete.
 */
async function insertFileData(fileData) {
    return new Promise(function (resolve, reject) {
      const boundary = '-------314159265358979323846';
      const delimiter = "\r\n--" + boundary + "\r\n";
      const close_delim = "\r\n--" + boundary + "--";

      var reader = new FileReader();
      reader.readAsBinaryString(fileData);
      reader.onload = function(e) {
        var contentType = fileData.type || 'application/octet-stream';
        //console.log('fileData',fileData)
        var metadata = {
          'title': fileData.fileName,
          'mimeType': contentType,
        };

        var base64Data = btoa(reader.result);
        var multipartRequestBody =
            delimiter +
            'Content-Type: application/json\r\n\r\n' +
            JSON.stringify(metadata) +
            delimiter +
            'Content-Type: ' + contentType + '\r\n' +
            'Content-Transfer-Encoding: base64\r\n' +
            '\r\n' +
            base64Data +
            close_delim;

        var request = gapi.client.request({
            'path': '/upload/drive/v2/files',
            'method': 'POST',
            'params': {'uploadType': 'multipart'},
            'headers': {
              'Content-Type': 'multipart/mixed; boundary="' + boundary + '"'
            },
            'body': multipartRequestBody});
         let callback = function(file) {
            if (request.error)reject(request.error)
            resolve(file)
          };
        request.execute(callback);
      }
    })
}

async function getFile(file_id) {
    return new Promise(function (resolve, reject) {
        gapi.client.request({
            'path': '/drive/v3/files/' + file_id,
            'method': 'GET',
        }).execute(response => response.error ? reject(response.error) : resolve(response))
    })
}

async function listFiles() {
    return new Promise(function (resolve, reject) {
        gapi.client.request({
            'path': '/drive/v3/files',
            'method': 'GET',
            'params': {
                //spaces: 'appDataFolder'
                fields:"files(*)" //id, name, webViewLink,webContentLink, mimeType)"
            }
        }).execute(response => response.error ? reject(response.error) : resolve(response))
    })
};

async function setToken() {
    return new Promise(function (resolve, reject) {
        // check if Sync library is loaded
	    chrome.identity.getAuthToken({interactive: true},function(token){
	        if (gapi.load && token) {
	            // init gapi libraries that we need
	            gapi.load('client:auth2', function () {
	                // assign access token for requests
	                gapi.client.setToken({access_token: token});
	                resolve({gapi,token});
	                //console.log('Token loaded')
	            })
	        }
          else reject('error setting token')
	    })        
    })
}

let reader = new FileReader();
let blob,fileToSend,globalStream

function streamHandler(stream) {
  rec = new MediaRecorder(stream);

  rec.ondataavailable = e => {
    let audioChunks = [];
    audioChunks.push(e.data);
    if (rec.state == "inactive"){
      blob = new Blob(audioChunks,{type:recordingType+'/webm'});
      fileToSend = blobToFile(blob, 'test.webm')
      $(recordingType).src = URL.createObjectURL(blob);
      $(recordingType).controls=true;
      $(recordingType).autoplay=true;
    }
  }
 }

function blobToFile(theBlob, fileName){
  theBlob.lastModifiedDate = new Date();
  theBlob.name = fileName;
  return theBlob;
}

function startStream(){
  navigator.mediaDevices.getUserMedia({audio:true,video:(recordingType=='video')})
  .then(stream => {
    globalStream=stream
    $(recordingType).srcObject = stream
    streamHandler(stream)
  }).catch((e)=>{
    stateChange('error')
  })
}

$('#startRecording').onclick = e => {
  $(recordingType).srcObject = globalStream
  rec.start();
}
$('#stopRecording').onclick = e => {
  rec.stop();
  $(recordingType).srcObject = undefined
}
